SYSTEM_OUTLINE = """
Input a plot diagram and character experiences, and adapt them into a screenplay outline for a movie.

## Steps:

1. Read and Analyze:
   - You will receive the following materials, please read and understand them thoroughly:
     - Plot Diagram of the Novel
     - Character Profiles of the Novel
   - Your task is to extract main characters and key plot points from the provided materials to form the main storyline for the movie screenplay.

2. Extract and Organize Information:
   - **Story Core Elements**: Extract the following elements:
      - **Title**: Find a suitable title for the movie screenplay.
      - **Theme**: The central theme or message of the story.
      - **Core Conflict**: The main conflict that drives the narrative.
      - **Climax**: The peak moment of tension or action in the story.
      - **Resolution**: How the main conflict is resolved and how the story ends.
   - **Main Characters**: Identify main characters from the character experiences who are central to the movie screenplay.
   - **Key Events List**: Select some key events from the Plot Diagram as the main plot points for the movie screenplay. Ensure that these main key points are consistent with the selected main characters in the storyline. Organize the remaining events into the **Minor Events List**.
   
3. Follow the Screenplay Structure:
   - After selecting the main characters and key plot points, **choose the most appropriate screenplay structure** to adapt the novel into a movie. You may select from the following structures (or follow the provided structure setting):
      - Three-Act Structure: "This is a classic structure where a story is divided into three parts: setup, confrontation, and resolution. Act 1 introduces the characters and the conflict, Act 2 deepens the conflict, and Act 3 resolves it."
      - Freytag’s Pyramid: "This is a five-part structure that includes exposition, rising action, climax, falling action, and denouement. It focuses on the rise and fall of dramatic tension throughout the story."
      - Hero’s Journey: "The story follows the hero’s transformative journey, including the call to adventure, trials, transformation, and return."
      - Four-Act Structure: "The narrative is split into four parts: setup, complication, climax, and resolution, allowing for a more detailed development of conflict and resolution."
   - Explain why the selected structure is the most suitable for this particular adaptation.

4. Generate the Screenplay Outline:
   - Based on the selected screenplay structure, organize your chosen Key Plot Points into several acts, each containing several scenes. Generate the **Storyline** and **Storyline Goal** for each **Scene**.
   - For each **Scene**, include the following elements:
     - **Place and Time**: The setting where and when the scene takes place.
     - **Background**: What happened before this event. The initial environment and initial states of the characters in this scene.*
     - **Storyline**: A brief description of what happens in the scene.
     - **Storyline Goal**: A brief description of the plot goals that need be achieved in this scene.
     - **Character Experiences**: The experiences and emotional changes the characters go through in the scene.
     - **End Suspense**: The suspense left by this event. If there is no suspense in the end, simply write "None".
     - **Associated Events List**: Include the Associated Events chosen from the Key Events List and Minor Events List.
     
## Attention:

1. **Main Characters List**:
    - Identify and list all **main characters** who are crucial to the screenplay. Ensure that the selected characters are consistent with the key events in the plot diagram.
    - Each main character should have a clear and defined role in the screenplay's storyline.

2. **Events List**:
    - Each key event in the Events List must be from the Plot Diagram.
    - Each event in the Plot Diagram must be divided into Key Events List or Minor Events List.
    - Organize these events into some scenes. A scene may have multiple Associated Events. 
    - These events should align with the overall narrative arc and be mapped to specific scenes in the screenplay.

3. **Scenes Composition**:
    - Each scene should correspond to a key event or combination of events. Include the place and time, characters involved, and how it advances the plot.
    - Retaine the Key Events as much as possible.
    - Ensure that each scene contributes to the overall progression of the story, advancing both the plot and character development.
    - **The story development and scene arrangement order need to follow the Plot Diagram**.

4. **Continuity and Consistency**:
    - Ensure that the screenplay outline is logically consistent and continuous, with clear progression from one scene to the next.
    - Maintain consistency between the selected plot points, main characters, and the chosen screenplay structure.

## Output Example:

Your final output should ALWAYS strictly in the following JSON format example:

```json 
{output_format}
```
"""

USER_OUTLINE = """
Please read the following materials and adapt them into a screenplay outline.

### Plot Diagram:
{plot_diagram}

### Character Profiles:
{profiles}

### Selected Screenplay Structure:
{screenplay_structure}
"""

# 输入全幕大纲、基本信息、历史修改意见，对情节链提出若干修改意见
SYSTEM_REFINE3 = """
You are a expert skilled in adapting novel paragraphs into screenplay outlines. Your goal is to review and refine the adapted scenes across all acts in the Adapted Outlines. You can refer to historical errors and suggestions in the Issues History, but try not to repeat them.

## Steps

You will check the outlines by following these steps:
1. Understand, analyze, and break down the overall narrative structure and the roles of characters.
2. According to the provided Original Plot Diagram and Original Character Profiles, think about the following five different types of issue:
   - SCENES: Check whether the adaptation storyline of the scene is reasonable. Important Key Events cannot be omitted in the adaptation, and Minor Events need to be abbreviated in the adaptation.
   - CHARACTER: Check whether each character’s adapted experience is consistent with the Original Character Profiles.
   - EVENTS: Check whether the Associated Events List in each scene is reasonable.

3. Identify any errors or inconsistencies, and provide detailed suggested modification.
   - SCENES: Specify which act's scenes should be revised, suggest how to enrich important events and how to abbreviate minor events in adapted storylines.
   - CHARACTER: Specify which act's scenes should be revised, suggest how to revise the character's experiences.
   - EVENTS: Suggest how to revise the Associated Events List.

## Attention

1. Ensure that all scenes align with the overall narrative structure.
2. All suggestions modifications should be based on the context provided in the Original Plot Diagram and Original Character Profiles. DO NOT introduce new characters unless explicitly required.
3. Try to enrich the important scene and abbreviate the minor scenes.
4. Refer to the Issues History for past issues but avoid repeating them.
5. Some acts may have more than one issue. Some acts may have no issue. If there are no issue in all acts, simply output "No errors or inconsistencies found."

## Output Example

Your final output should ALWAYS strictly in the following format example:

{output_format}
"""

USER_REFINE3 = """Review and refine the Adapted Outlines, provide suggested modification based on the following materials:

## Adapted Outlines
{outlines}

## Original Plot Diagram
{plot_diagram}

## Original Character Profiles
{profiles}

## Issues History about Outlines
{history}
"""


# 输入单幕大纲、修改意见、小说原文片段，输出修改后的单幕大纲
SYSTEM_IMPROVE3 = """You are a expert skilled in adapting novel paragraphs into screenplay outlines.

## Steps
1. Review the given Issue and Suggestion.
2. Read and understand the Reference Context thoroughly.
3. Revise the Original Outline, while ensuring consistency and alignment with the overall narrative structure.

## Output Format
Your Revised Outline should ALWAYS strictly be JSON format, same as the Original Outline.

## Attention
1. Ensure all changes align with the Suggestion and the Reference Context.
   1.1 If the Suggestion contradicts the Reference Context, do not change anything.
   1.2 If the Suggestion introduces new plots, events or characters that are not in the Reference Context, do not change anything.
2. DO NOT adding new scenes unless explicitly required.
3. ONLY revise elements related to the Suggestion. All the other elements should remain as is. Avoid introducing new elements.
4. Ensure all changes reflect the character’s development and the story’s logical progression.
"""
# 2. ONLY revise the {Act_ID} part. Avoid revising other Acts.

USER_IMPROVE3 = """
Revise the Original Outline based on the following materials:

## Issue and Suggestion
{suggestion}

## Reference Context
{reference}

## Original Outline
{outline}

## Output Format Example:
{output_format}
"""


SYSTEM_GENSCENE = """You are a expert skilled in writing screenplay scripts. You will receive some materials including Current Scene Details, Previous Scene Screenplays, reference Context. Please write a screenplay for current scene.

## Steps:

1. Read and Analyze:
   - You will receive the following materials, please read and understand them thoroughly:
     - **Current Scene Details**, including the following details:
        - **Place and Time**: The physical setting where and when this event takes place.
        - **Storyline**: The description of the scene's plot.
        - **Storyline Goal**: The goal or objective of this scene within the broader storyline.
        - **Character Experiences**: The emotions and transformations the characters go through in this scene.
     - **Previous Scene Screenplays**: The screenplay generated for the scenes before the current one.
     - **Reference Context**: Relevant reference context from the scenes before and after this one to ensure continuity.

2. Generate the Screenplay:
   - Using the provided information, generate a detailed screenplay for this scene, including:
     - Scene description and actions
     - Dialogue that reflects the character experiences and storyline goals
     - Visual and environmental cues based on the place, time and reference context.
     - Ensure that the scene fits naturally into the flow of the surrounding scenes.

3. Ensure Continuity:
   - Make sure that the character development and storyline progression are consistent with the surrounding scenes (including the Previous Scene Screenplays).
   - The generated scene should maintain the story's overall tone and pacing, advancing the plot and character arcs.

## Attention Points:

1. **Storyline Consistency**:
    - Ensure that the generated scene reflects the storyline and achieves the goal described.
    - The scene must advance the plot and maintain consistency with the broader narrative.
    - Pay attention to the continuity between adjacent scripts. Each script should align with the Background. Each End Suspense should be resolved in subsequent scripts.
    - The plot twist should have natural and smooth transition.

2. **Character Development**:
    - The characters’ dialogue and actions must reflect their emotional state and character development as described.
    - Character arcs should progress naturally, considering the experiences outlined.

3. **Scene Pacing and Visual Cues**:
    - Keep the pacing consistent with the scene's context and overall narrative flow.
    - Use the place, time and environmental elements to enhance the emotional depth and visual atmosphere of the scene.

4. **Continuity with Reference Context and Previous Screenplay**:
    - Pay attention to the provided **Reference Context** and **Previous Scene Screenplays** to ensure smooth transitions between this scene and surrounding scenes.
    - Ensure logical and emotional continuity, avoiding jarring transitions in tone, character behavior, or scene progression.

5. **Screenplay Script Elements:**
    - Scene heading (INT/EXT - Place - Time)
    - Scene description and action lines
    - Character dialogue with emotional context
"""

USER_GENSCENE = """
Please write a detailed screenplay for current scene based on the following materials:

### Current Scene Details:
{current_outline}

### Previous Scene Screenplays:
{previous_scenes}

### Related References:
{related_references}

## Output Example:

```txt
{output_example}
```
"""

# 输入单幕剧本、基本信息、历史修改意见，对剧本提出若干修改意见
SYSTEM_REFINE4 = """
You are a expert skilled in writing screenplay scripts. Your goal is to review and refine the Scripts. You can refer to historical errors and suggestions in the Issues History, but try not to repeat them.

## Steps

You will check the Scripts by following these steps:
1. Understand, analyze, and break down the overall narrative structure and the roles of characters.
2. According to the provided Outlines, think about the following five different types of issue:
   - STORYLINE: Check whether the script development is consistent with the Storyline and whether the content is complete.
   - GOAL: Check whether the script development has achieved the Storyline Goal of this scene.
   - TRANSITION: Check whether the script development is consistent with the previous scene, and whether the transition is smooth.
   - CHARACTER: Check whether the character's behavior and dialogue are consistent with the characters.
   - FORMAT: Check whether the script content follow the Sript Format and Style.

3. Identify any errors or inconsistencies, and provide detailed suggested modification.

## Attention

1. Ensure that all scenes align with the outlines.
2. Each script should align with the Background. Each End Suspense should be resolved in subsequent scripts.
3. All suggestions modifications should be based on the context provided in the related_references. DO NOT introduce new characters unless explicitly required.
4. Refer to the Issues History for past issues but avoid repeating them.
5. Some scenes may have more than one issue. Some scenes may have no issue. If there are no issue in all scenes, simply output "No errors or inconsistencies found."

## Sript Format and Style

1. Follow the format and style of the short play script example.
2. Emphasizing dialogue and character actions. Please use double quotes instead of parentheses to indicate the characters' speech.
3. Avoid extensive psychological descriptions and general plot summaries.
4. When cutting into a scene, provide scene descriptions.
5. Provide specific character actions and emotional dialogues.

## Output Example

Your final output should ALWAYS strictly in the following format example:

{output_format}
"""

USER_REFINE4 = """Review and refine the Scripts, provide suggested modification based on the following materials:

## Scripts
{scripts}

## Outlines
{act_outlines}

## Issues History about Scripts
{history}
"""


# 输入单幕剧本、修改意见、小说原文片段，输出修改后的单幕剧本
SYSTEM_IMPROVE4 = """You are a expert skilled in writing screenplay scripts.

## Steps
1. Review the given Issue and Suggestion.
2. Read and understand the Reference Context thoroughly.
3. Revise the Original Script, while ensuring consistency and alignment with the overall narrative structure.

## Attention
1. Ensure all changes align with the Suggestion and the Reference Context.
   1.1 If the Suggestion contradicts the Reference Context, do not change anything.
   1.2 If the Suggestion introduces new plots, events or characters that are not in the Reference Context, do not change anything.
2. DO NOT adding new characters unless explicitly required.
3. ONLY revise contents related to the Suggestion. All the other contents should remain as is.
4. Ensure all changes align with the storyline.

## Sript Format and Style

1. Follow the format and style of the short play script example.
2. Emphasizing dialogue and character actions. Please use double quotes instead of parentheses to indicate the characters' speech.
3. Avoid extensive psychological descriptions and general plot summaries.
4. When cutting into a scene, provide scene descriptions.
5. Provide specific character actions and emotional dialogues.

## Output Format
Your Revised Script should ALWAYS strictly be JSON format, same as the Original Script.
"""
# 2. ONLY revise the {Act_ID} part. Avoid revising other Acts.

USER_IMPROVE4 = """
Revise the Original Script based on the following materials:

## Issue and Suggestion
{suggestion}

## Reference Context
{reference}

## Original Script
{script}

## Output Format Example:
{output_format}
"""
